unit Mainfrm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.Menus, Vcl.ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    MainMenu1: TMainMenu;
    Open1: TMenuItem;
    BplForm1: TMenuItem;
    procedure BplForm1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    procedure LoadMDIForm(BplFile, TFrmName : String);

  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

var
  BPLHandle : Cardinal;//HModule;
  AForm : TForm;
  LoadedBplFileName : String;


{ TForm1 }
procedure TForm1.BplForm1Click(Sender: TObject);
begin
  LoadMDIForm('bplForm.bpl' , 'TForm2');
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if BPLHandle <> 0 then
  begin
    UnRegisterModuleClasses(BPLHandle);
    UnloadPackage(BPLHandle);     //жذ
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  LoadedBplFileName := '';
end;

procedure TForm1.LoadMDIForm(BplFile, TFrmName: String);
var
  AClass : TClass;
begin
  if Not FileExists(ExtractFilePath(paramstr(0)) + BplFile) then
  begin
    Application.MessageBox(PChar('Ҳļ ' + BplFile) , 'MSG', MB_OK);
    Exit;
  end;

  Try
    if (AForm <> Nil) And (AForm.Showing) then FreeAndNil(AForm);
    if LoadedBplFileName <> BplFile then
    begin
      if BPLHandle <> 0 then
      begin
        UnloadPackage(BPLHandle);
        BPLHandle := 0;
      end;
      BPLHandle := LoadPackage(BplFile);
    end;
    AClass := GetClass(TFrmName);
    if AClass <> nil then
    begin
      Application.CreateForm(TComponentClass(AClass) , AForm);
      AForm.parent := Form1.Panel1;
      AForm.bringToFront;
      AForm.Show;
    end;
  Except
    on E: Exception do
    begin
      Application.MessageBox(PChar('ǶʧܣϢ£'+#13+ E.Message ) , 'Ĺ', MB_OK);
      Exit;
    end;
  End;
  LoadedBplFileName := BplFile;
end;

end.
